import { StyleSheet, Dimensions } from 'react-native';
import dpr from '../../Utilities/CustomStyleAttribute/dpr';

const {width} = Dimensions.get('screen')

export const orderHistoryStyle = StyleSheet.create({
    itemsContainer: {
        flex: 1,
        backgroundColor: '#fff',
        paddingHorizontal: dpr(20),
    },
    mt20: { marginTop: dpr(20) },
    itemsView: {},
    filterCont: {
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between',
        marginTop: dpr(30),
        width: dpr('wf') - dpr(40),
    },
    filterText: {
        fontFamily: 'DMSans_500Medium',
        fontSize: dpr(16),
        color: '#2C2C2C',
        width: (dpr('wf') - dpr(30))/ 4,
    },
    item: {
        borderWidth: 1,
        borderColor: '#DFDFDF',
        marginTop: dpr(20),
        borderRadius: dpr(6),
        padding: dpr(15),
    },
    mb20Optional: (length, index) => ({
        marginBottom: length - 1 == index ? dpr(20) : 0,
    }),
    header: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        alignItems: 'center',
        marginBottom: dpr(10),
    },
    headerText: {
        fontFamily: 'DMSans_500Medium',
        fontSize: dpr(15),
        color: '#2C2C2C',
        width: '65%',
        textAlign: 'left'
    },
    info: {
        flexDirection: 'row',
        flexWrap: 'wrap',
    },
    infoTextCont: {
        flexDirection: 'row',
        alignItems: 'center',
        marginRight: dpr(12),
    },
    infoText: {
        fontFamily: 'Roboto_500Medium',
        fontSize: dpr(12),
        color: '#898989',
        marginLeft: dpr(7),
    },
    orderSelectInputCont: {
        width: width < 335 ? (dpr('wf') - dpr(30))/ 3.5 : dpr('wf') / 3.5,
        paddingHorizontal: dpr(10),
        height: dpr(42),
    },
});
